﻿<?php
session_start();

// O script de retorno restaura a sessão original do Diretor.

// 1. Verifica se a sessão de simulação existe
if (isset($_SESSION['diretor_original'])) {
    
    // Pega o nome do Diretor original para a mensagem de boas-vindas
    $nome_diretor = $_SESSION['diretor_original']['nome'] ?? 'Diretor';

    // 2. RESTAURA A SESSÃO: Sobrescreve a sessão do professor com a sessão do Diretor
    $_SESSION['usuario'] = $_SESSION['diretor_original'];
    
    // 3. LIMPA AS VARIÁVEIS DE CONTROLE: Remove as flags de simulação
    unset($_SESSION['diretor_original']);
    unset($_SESSION['simulando']);
    
    // 4. ADICIONA MENSAGEM: Prepara uma mensagem para ser exibida no painel do Diretor
    $_SESSION['mensagem_retorno_diretor'] = "✅ Bem-vindo de volta, " . htmlspecialchars($nome_diretor) . "! Você saiu da simulação com sucesso.";

    // 5. REDIRECIONA: Volta para a página lógica (lista de professores) para que o Diretor possa continuar a gestão.
    // **NOTA:** Se o painel principal do Diretor for 'painel.php', altere 'listar_professores.php' para 'painel.php'.
    header("Location: listar_professores.php"); 
    exit;
} else {
    // Caso tente acessar diretamente sem simular, volta ao painel principal do diretor.
    header("Location: painel_subpedagogico.php");
    exit;
}
?>